<?php
// Start session
session_start();
// Include database connection
require_once 'config.php';
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Cleaning and pool service template | Vecuro | Home 3</title>
    <meta name="author" content="Vecuro">
    <meta name="description" content="Cleaning and pool Home 3 template">
    <meta name="keywords" content="Cleaning and pool Home 3 template">
    <meta name="robots" content="INDEX,FOLLOW">

    <!-- Mobile Specific Metas -->
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Favicons - Place favicon.ico in the root directory -->
    <link rel="shortcut icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="icon" href="assets/img/favicon.ico" type="image/x-icon">

    <!--==============================
	  Google Fonts
	============================== --> 
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="../../css2-2?family=Fuzzy+Bubbles:wght@400;700&family=Poppins:wght@400;500;600;700;800&family=Rubik:ital,wght@0,300..900;1,300..900&display=swap" rel="stylesheet">


    <!--==============================
	    All CSS File
	============================== -->
    <!-- Bootstrap -->
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <!-- Fontawesome Icon -->
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <!-- Magnific Popup -->
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <!-- Slick Slider -->
    <link rel="stylesheet" href="assets/css/slick.min.css">
    <!-- animate js -->
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <!-- Theme Custom CSS -->
    <link rel="stylesheet" href="assets/css/style.css">

    <!-- Sticky Header & Auth Modals CSS -->
    <style>
        /* =====================================
           STICKY HEADER STYLES
        ===================================== */
        
        .vs-header .sticky-wrapper {
            position: sticky;
            top: 0;
            z-index: 1030;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            animation: slideDown 0.3s ease-in-out;
        }
        
        @keyframes slideDown {
            from {
                transform: translateY(-100%);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        /* =====================================
           AUTH BUTTONS STYLES
        ===================================== */
        
        .auth-buttons {
            display: flex;
            gap: clamp(8px, 1.5vw, 16px);
            align-items: center;
            flex-wrap: wrap;
        }

        .auth-btn {
            padding: clamp(8px, 1.2vw, 14px) clamp(12px, 2vw, 18px);
            border: 2px solid transparent;
            border-radius: 8px;
            font-size: clamp(12px, 1.5vw, 16px);
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 6px;
            white-space: nowrap;
            background: transparent;
        }

        .login-btn {
            color: #109c3d;
            border-color: #109c3d;
        }

        .login-btn:hover {
            background: #109c3d;
            color: #ffffff;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(16, 156, 61, 0.3);
        }

        .register-btn {
            background: #109c3d;
            color: #ffffff;
            border-color: #109c3d;
        }

        .register-btn:hover {
            background: linear-gradient(135deg, #0f8c3d, #109c3d);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(16, 156, 61, 0.4);
        }

        /* =====================================
           AUTH BUTTONS RESPONSIVE
        ===================================== */
        @media (max-width: 991px) {
            .auth-buttons {
                display: none;
            }
        }

        /* =====================================
           MODAL STYLES
        ===================================== */
        
        .modal-dialog {
            animation: slideUp 0.4s ease-out;
        }

        @keyframes slideUp {
            from {
                transform: translateY(30px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        .modal-content {
            border: none;
            border-radius: 16px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.15);
            background: #ffffff;
        }

        .modal-header {
            border-bottom: 2px solid #f1f5f4;
            padding: clamp(20px, 3vw, 30px);
            background: linear-gradient(135deg, #f8fbff, #f1f5f4);
            border-radius: 16px 16px 0 0;
        }

        .modal-header .btn-close {
            filter: invert(0.5);
        }

        .modal-header .btn-close:hover {
            filter: invert(0);
        }

        .modal-title {
            font-size: clamp(18px, 2vw, 24px);
            font-weight: 700;
            color: #109c3d;
            text-transform: capitalize;
        }

        .modal-body {
            padding: clamp(25px, 4vw, 40px);
        }

        .form-group {
            margin-bottom: clamp(15px, 2vw, 20px);
        }

        .form-label {
            font-size: clamp(13px, 1.3vw, 15px);
            font-weight: 600;
            color: #063a41;
            margin-bottom: 8px;
            display: block;
        }

        .form-control {
            padding: clamp(10px, 1.5vw, 14px) clamp(12px, 1.8vw, 16px);
            font-size: clamp(13px, 1.3vw, 15px);
            border: 1.5px solid #cdd5d6;
            border-radius: 8px;
            transition: all 0.3s ease;
            width: 100%;
            font-family: inherit;
        }

        .form-control:focus {
            border-color: #109c3d;
            outline: none;
            box-shadow: 0 0 0 3px rgba(16, 156, 61, 0.1);
            background-color: #f8fbff;
        }

        .form-control::placeholder {
            color: #a8aca8;
        }

        .form-check {
            margin-bottom: clamp(12px, 1.5vw, 16px);
        }

        .form-check-input {
            width: 20px;
            height: 20px;
            margin-top: 2px;
            border: 1.5px solid #cdd5d6;
            border-radius: 4px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .form-check-input:checked {
            background-color: #109c3d;
            border-color: #109c3d;
        }

        .form-check-input:focus {
            border-color: #109c3d;
            box-shadow: 0 0 0 3px rgba(16, 156, 61, 0.1);
        }

        .form-check-label {
            font-size: clamp(12px, 1.1vw, 14px);
            color: #5e5c78;
            margin-left: 8px;
            cursor: pointer;
        }

        .form-link {
            color: #109c3d;
            text-decoration: none;
            font-weight: 600;
            transition: color 0.3s ease;
        }

        .form-link:hover {
            color: #0f8c3d;
            text-decoration: underline;
        }

        .auth-divider {
            display: flex;
            align-items: center;
            margin: clamp(20px, 3vw, 28px) 0;
            font-size: clamp(12px, 1.1vw, 13px);
            color: #5e5c78;
        }

        .auth-divider::before,
        .auth-divider::after {
            content: "";
            flex: 1;
            height: 1px;
            background: #cdd5d6;
        }

        .auth-divider::before {
            margin-right: 12px;
        }

        .auth-divider::after {
            margin-left: 12px;
        }

        .social-auth-buttons {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: clamp(12px, 2vw, 16px);
        }

        .social-auth-btn {
            padding: clamp(10px, 1.5vw, 14px);
            border: 1.5px solid #cdd5d6;
            border-radius: 8px;
            background: #ffffff;
            cursor: pointer;
            font-size: clamp(11px, 1vw, 13px);
            font-weight: 600;
            color: #063a41;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 6px;
        }

        .social-auth-btn:hover {
            background: #f1f5f4;
            border-color: #109c3d;
            color: #109c3d;
            transform: translateY(-2px);
        }

        .modal-footer {
            padding: clamp(15px, 2.5vw, 20px) clamp(25px, 4vw, 40px);
            border-top: 2px solid #f1f5f4;
            background: #f8fbff;
        }

        .btn-submit {
            width: 100%;
            padding: clamp(12px, 1.8vw, 16px);
            font-size: clamp(14px, 1.4vw, 16px);
            font-weight: 700;
            background: linear-gradient(135deg, #109c3d, #0f8c3d);
            color: #ffffff;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(16, 156, 61, 0.3);
        }

        .btn-submit:active {
            transform: translateY(0);
        }

        .toggle-auth {
            text-align: center;
            font-size: clamp(13px, 1.2vw, 15px);
            color: #5e5c78;
            margin-top: clamp(16px, 2vw, 20px);
        }

        .toggle-auth-link {
            color: #109c3d;
            font-weight: 700;
            cursor: pointer;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .toggle-auth-link:hover {
            color: #0f8c3d;
        }

        /* =====================================
           RESPONSIVE DESIGN
        ===================================== */
        
        @media (max-width: 767px) {
            .auth-buttons {
                gap: 6px;
            }

            .auth-btn {
                padding: 8px 10px;
                font-size: 12px;
            }

            .auth-btn i {
                font-size: 16px;
            }

            .modal-dialog {
                margin: 20px 16px;
            }

            .modal-content {
                border-radius: 12px;
            }

            .modal-header,
            .modal-body,
            .modal-footer {
                padding: 15px 20px;
            }

            .social-auth-buttons {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 575px) {
            .auth-btn span {
                display: none !important;
            }

            .modal-dialog {
                margin: 10px 10px;
            }

            .form-group {
                margin-bottom: 12px;
            }

            .modal-title {
                font-size: 18px;
            }
        }
    </style>

</head>

<body>
    <!--==============================
	Preloader
	==============================-->
    <!-- <div class="preloader">
        <button class="vs-btn preloaderCls">Cancel Preloader </button>
        <div class="preloader-inner">
        <img src="assets/img/logo.svg" alt="logo">
        <span class="loader"></span>
        </div>
    </div> -->

    <!-- Include Header -->
    <?php include 'header.php'; ?>

    <!--================================
			Start Main Content
	  ================================ -->
    <!-- Hero Area -->
    <!-- Fresh Hero Slider Section - Cleaning Service -->
    <section class="hero-slider-section">
        <style>
            /* =====================================
   FRESH HERO SLIDER - FULLY RESPONSIVE
===================================== */

.hero-slider-section {
    position: relative;
    width: 100%;
    height: clamp(500px, 90vh, 850px);
    overflow: hidden;
    background: linear-gradient(135deg, #f8fbff 0%, #e8f5ff 100%);
}

/* HERO SLIDER CONTAINER */
.hero-slider-wrapper {
    position: relative;
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
}

/* SINGLE SLIDE */
.hero-slide {
    position: absolute;
    inset: 0;
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    padding: clamp(40px, 6vw, 80px) clamp(20px, 4vw, 50px);
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    opacity: 0;
    visibility: hidden;
    transition: opacity 0.8s ease-in-out, visibility 0.8s ease-in-out;
}

.hero-slide.active {
    opacity: 1;
    visibility: visible;
}

.hero-slide::before {
    content: "";
    position: absolute;
    inset: 0;
    background: linear-gradient(135deg, rgba(16, 156, 61, 0.1), rgba(79, 172, 254, 0.05));
    z-index: 1;
}

/* SLIDE CONTENT GRID */
.hero-slide-content {
    position: relative;
    z-index: 2;
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: clamp(30px, 5vw, 60px);
    align-items: center;
    width: 100%;
    max-width: 1400px;
    margin: 0 auto;
}

/* TEXT CONTENT */
.hero-text-content {
    display: flex;
    flex-direction: column;
    gap: clamp(16px, 2.5vw, 28px);
}

.hero-badge {
    display: inline-flex;
    align-items: center;
    gap: clamp(8px, 1.5vw, 12px);
    width: fit-content;
    padding: clamp(8px, 1.2vw, 14px) clamp(14px, 2vw, 20px);
    background: rgba(16, 156, 61, 0.12);
    border-radius: clamp(6px, 1vw, 10px);
    font-size: clamp(11px, 1.1vw, 13px);
    font-weight: 700;
    color: #109c3d;
    text-transform: uppercase;
    letter-spacing: 0.8px;
}

.hero-badge i {
    font-size: clamp(14px, 1.5vw, 18px);
}

.hero-heading {
    font-size: clamp(32px, 5.5vw, 60px);
    font-weight: 900;
    line-height: clamp(1.15, 1.25, 1.35);
    color: #0f172a;
    letter-spacing: -0.8px;
}

.hero-heading .highlight {
    color: #109c3d;
    position: relative;
}

.hero-heading .highlight::after {
    content: "";
    position: absolute;
    bottom: -8px;
    left: 0;
    right: 0;
    height: 4px;
    background: linear-gradient(90deg, #109c3d, #4facfe);
    border-radius: 2px;
}

.hero-description {
    font-size: clamp(14px, 1.3vw, 18px);
    line-height: clamp(1.6, 1.75, 1.9);
    color: #475569;
    max-width: 95%;
}

.hero-cta-buttons {
    display: flex;
    gap: clamp(12px, 2vw, 20px);
    flex-wrap: wrap;
    margin-top: clamp(8px, 1vw, 16px);
}

.btn-hero {
    padding: clamp(12px, 1.5vw, 18px) clamp(22px, 3.5vw, 36px);
    font-size: clamp(13px, 1.2vw, 16px);
    font-weight: 700;
    border: none;
    border-radius: clamp(8px, 1.2vw, 12px);
    cursor: pointer;
    transition: all 0.35s cubic-bezier(0.4, 0, 0.2, 1);
    display: inline-flex;
    align-items: center;
    gap: 10px;
    text-decoration: none;
    white-space: nowrap;
}

.btn-hero.btn-primary {
    background: linear-gradient(135deg, #109c3d 0%, #0f8c3d 100%);
    color: #ffffff;
    box-shadow: 0 10px 30px rgba(16, 156, 61, 0.4);
}

.btn-hero.btn-primary:hover {
    transform: translateY(-4px);
    box-shadow: 0 16px 45px rgba(16, 156, 61, 0.5);
}

.btn-hero.btn-secondary {
    background: transparent;
    color: #109c3d;
    border: 2.5px solid #109c3d;
}

.btn-hero.btn-secondary:hover {
    background: #109c3d;
    color: #ffffff;
    transform: translateY(-4px);
}

/* STATS */
.hero-stats {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: clamp(20px, 3vw, 30px);
    margin-top: clamp(32px, 4vw, 48px);
    padding-top: clamp(24px, 3vw, 36px);
    border-top: 2px solid rgba(16, 156, 61, 0.15);
}

.stat-item {
    text-align: center;
}

.stat-number {
    font-size: clamp(24px, 3vw, 38px);
    font-weight: 900;
    color: #109c3d;
}

.stat-label {
    font-size: clamp(12px, 1vw, 14px);
    color: #64748b;
    margin-top: 4px;
    font-weight: 600;
}

/* IMAGE CONTENT */
.hero-image-content {
    position: relative;
    height: 100%;
    min-height: clamp(350px, 50vh, 550px);
    display: flex;
    align-items: center;
    justify-content: center;
}

.hero-image {
    width: 100%;
    height: 100%;
    border-radius: clamp(14px, 2.5vw, 22px);
    overflow: hidden;
    box-shadow: 0 25px 70px rgba(0, 0, 0, 0.18);
}

.hero-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    display: block;
}

.image-decoration {
    position: absolute;
    opacity: 0.8;
    pointer-events: none;
}

/* SLIDER CONTROLS */
.hero-slider-controls {
    position: absolute;
    bottom: 11px;
    left: clamp(20px, 4vw, 50px);
    z-index: 5;
    display: flex;
    gap: clamp(10px, 1.5vw, 16px);
    align-items: center;
}

.slider-dot {
    width: clamp(8px, 1.2vw, 12px);
    height: clamp(8px, 1.2vw, 12px);
    border-radius: 50%;
    background: rgba(16, 156, 61, 0.3);
    cursor: pointer;
    transition: all 0.3s ease;
    border: 2px solid transparent;
}

.slider-dot.active {
    background: #109c3d;
    transform: scale(1.3);
    box-shadow: 0 0 0 4px rgba(16, 156, 61, 0.2);
}

.slider-dot:hover {
    background: rgba(16, 156, 61, 0.6);
}

.slider-nav-btn {
    width: clamp(40px, 5vw, 50px);
    height: clamp(40px, 5vw, 50px);
    border-radius: 50%;
    background: rgba(16, 156, 61, 0.9);
    border: none;
    color: #ffffff;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: clamp(16px, 2vw, 22px);
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(16, 156, 61, 0.3);
    margin: 0 clamp(6px, 1vw, 10px);
}

.slider-nav-btn:hover {
    background: #109c3d;
    transform: scale(1.1);
    box-shadow: 0 6px 20px rgba(16, 156, 61, 0.5);
}

.slider-nav-btn:active {
    transform: scale(0.95);
}

.slider-counter {
    font-size: clamp(12px, 1.2vw, 14px);
    font-weight: 700;
    color: #0f172a;
    margin-left: clamp(12px, 2vw, 18px);
    padding-left: clamp(12px, 2vw, 18px);
    border-left: 2px solid rgba(16, 156, 61, 0.3);
}

/* FLOATING ELEMENTS */
.float-shape {
    position: absolute;
    opacity: 0.7;
    animation: float-animation 4s ease-in-out infinite;
    pointer-events: none;
}

@keyframes float-animation {
    0%, 100% { transform: translateY(0) rotate(0deg); }
    50% { transform: translateY(-20px) rotate(3deg); }
}

.bubble-bg {
    position: absolute;
    border-radius: 50%;
    background: rgba(79, 172, 254, 0.08);
    animation: bubble-float 15s infinite ease-in;
    pointer-events: none;
    z-index: 0;
}

@keyframes bubble-float {
    0% { bottom: -10%; opacity: 0; }
    50% { opacity: 0.5; }
    100% { bottom: 110%; opacity: 0; }
}

/* =====================================
   TABLET (768px - 991px)
===================================== */

@media (max-width: 991px) {

    .hero-slider-section {
        height: clamp(450px, 85vh, 700px);
    }

    .hero-slide {
        padding: clamp(30px, 4vw, 60px) clamp(15px, 3vw, 30px);
    }

    .hero-slide-content {
        grid-template-columns: 1fr;
        text-align: center;
        gap: clamp(24px, 4vw, 40px);
    }

    .hero-text-content {
        align-items: center;
    }

    .hero-badge {
        justify-content: center;
        margin: 0 auto;
    }

    .hero-description {
        max-width: 100%;
    }

    .hero-cta-buttons {
        justify-content: center;
    }

    .hero-stats {
        margin-left: auto;
        margin-right: auto;
    }

    .hero-image-content {
        min-height: clamp(280px, 35vh, 400px);
    }
}

/* =====================================
   MOBILE (576px - 767px)
===================================== */

@media (max-width: 767px) {

    .hero-slider-section {
        height: clamp(400px, 80vh, 600px);
    }

    .hero-slide {
        padding: clamp(24px, 3vw, 40px) clamp(12px, 2.5vw, 20px);
    }

    .hero-slide-content {
        gap: clamp(18px, 3vw, 28px);
    }

    .hero-text-content {
        gap: clamp(12px, 1.8vw, 18px);
    }

    .hero-heading {
        font-size: clamp(24px, 3.8vw, 36px);
    }

    .hero-description {
        font-size: clamp(13px, 1.1vw, 15px);
    }

    .hero-cta-buttons {
        flex-direction: row;
        gap: clamp(8px, 1.2vw, 12px);
    }

    .btn-hero {
        flex: 1;
        min-width: 110px;
        padding: clamp(10px, 1.2vw, 14px) clamp(16px, 2.5vw, 20px);
        font-size: clamp(12px, 1vw, 14px);
    }

    .btn-hero i {
        font-size: 13px;
    }

    .hero-stats {
        margin-top: clamp(24px, 3vw, 32px);
        padding-top: clamp(18px, 2.5vw, 24px);
        gap: clamp(14px, 2vw, 18px);
    }

    .stat-number {
        font-size: clamp(20px, 2.5vw, 28px);
    }

    .stat-label {
        font-size: clamp(10px, 0.85vw, 12px);
    }

    .hero-image-content {
        min-height: clamp(240px, 30vh, 320px);
    }
}

/* =====================================
   SMALL MOBILE (Below 576px)
===================================== */

@media (max-width: 575px) {

    .hero-slider-section {
        height: clamp(350px, 75vh, 500px);
    }

    .hero-slide {
        padding: 20px 12px;
    }

    .hero-slide-content {
        gap: 14px;
    }

    .hero-badge {
        font-size: 10px;
        padding: 6px 10px;
        gap: 5px;
        margin: 0 auto;
    }

    .hero-badge i {
        font-size: 11px;
    }

    .hero-heading {
        font-size: clamp(20px, 3.2vw, 28px);
        letter-spacing: -0.4px;
    }

    .hero-heading .highlight::after {
        height: 3px;
    }

    .hero-description {
        font-size: 12px;
        line-height: 1.5;
    }

    .hero-cta-buttons {
        flex-direction: column;
        gap: 8px;
        width: 100%;
    }

    .btn-hero {
        width: 100%;
        padding: 10px 12px;
        font-size: 11px;
        gap: 8px;
    }

    .btn-hero i {
        font-size: 11px;
    }

    .hero-stats {
        margin-top: 14px;
        padding-top: 14px;
        gap: 10px;
        border-top: 1px solid rgba(16, 156, 61, 0.12);
    }

    .stat-item {
        text-align: center;
    }

    .stat-number {
        font-size: 16px;
    }

    .stat-label {
        font-size: 9px;
        margin-top: 2px;
    }

    .hero-image-content {
        min-height: clamp(200px, 25vh, 280px);
    }

    .hero-image {
        border-radius: 10px;
    }

    .hero-slider-controls {
        bottom: 12px !important;
        left: 12px !important;
        gap: 6px !important;
    }

    .slider-dot {
        width: 7px !important;
        height: 7px !important;
    }

    .slider-counter {
        font-size: 10px !important;
        margin-left: 6px !important;
        padding-left: 6px !important;
    }
}

/* =====================================
   DESKTOP (992px and above)
===================================== */

@media (min-width: 992px) {

    .hero-slider-section {
        height: clamp(500px, 90vh, 850px);
    }

    .hero-slide-content {
        grid-template-columns: 1fr 1fr;
    }

    .hero-text-content {
        align-items: flex-start;
    }

    .hero-badge {
        justify-content: flex-start;
    }

    .hero-heading {
        text-align: left;
    }

    .hero-description {
        text-align: left;
    }

    .hero-cta-buttons {
        justify-content: flex-start;
    }

    .btn-hero:hover i {
        transform: translateX(3px);
    }
}

/* =====================================
   LARGE SCREENS (1400px+)
===================================== */

@media (min-width: 1400px) {

    .hero-slider-section {
        height: 850px;
    }

    .hero-heading {
        font-size: 60px;
    }

    .hero-description {
        font-size: 18px;
    }

    .btn-hero {
        padding: 16px 32px;
        font-size: 16px;
    }

    .hero-image-content {
        min-height: 550px;
    }
}
    }

    .hero-slide {
        padding: clamp(30px, 4vw, 60px) clamp(15px, 3vw, 30px);
    }

    .hero-slide-content {
        grid-template-columns: 1fr;
        text-align: center;
    }

    .hero-text-content {
        align-items: center;
    }

    .hero-badge {
        justify-content: center;
    }

    .hero-description {
        max-width: 100%;
        margin: 0 auto;
    }

    .hero-cta-buttons {
        justify-content: center;
    }

    .hero-stats {
        justify-content: center;
        margin-left: auto;
        margin-right: auto;
    }

    .hero-image-content {
        min-height: clamp(300px, 40vh, 420px);
        margin-top: clamp(20px, 3vw, 30px);
    }

    .image-decoration {
        display: none;
    }
}

/* =====================================
   MOBILE (576px - 767px)
===================================== */

@media (max-width: 767px) {

    .hero-slider-section {
        min-height: clamp(400px, 80vh, 600px);
    }

    .hero-slide {
        padding: clamp(25px, 3vw, 40px) clamp(12px, 2.5vw, 20px);
    }

    .hero-slide-content {
        gap: clamp(20px, 3vw, 30px);
    }

    .hero-text-content {
        gap: clamp(12px, 2vw, 20px);
    }

    .hero-heading {
        font-size: clamp(26px, 4vw, 38px);
    }

    .hero-description {
        font-size: clamp(13px, 1.1vw, 15px);
    }

    .hero-cta-buttons {
        flex-direction: row;
        justify-content: center;
        gap: clamp(10px, 1.5vw, 14px);
    }

    .btn-hero {
        flex: 1;
        min-width: 120px;
        justify-content: center;
    }

    .hero-stats {
        grid-template-columns: repeat(3, 1fr);
        gap: clamp(16px, 2vw, 20px);
    }

    .stat-number {
        font-size: clamp(20px, 2.5vw, 28px);
    }

    .stat-label {
        font-size: clamp(11px, 0.9vw, 12px);
    }

    .hero-image-content {
        min-height: clamp(250px, 35vh, 350px);
        margin-top: clamp(16px, 2.5vw, 24px);
    }

    .hero-slider-controls {
        bottom: clamp(16px, 2.5vw, 30px);
        left: clamp(16px, 3vw, 30px);
    }
}

/* =====================================
   SMALL MOBILE (Below 576px)
===================================== */

@media (max-width: 575px) {

    .hero-slider-section {
        min-height: clamp(350px, 75vh, 500px);
    }

    .hero-slide {
        padding: 20px 12px;
    }

    .hero-slide-content {
        gap: 16px;
    }

    .hero-badge {
        font-size: 10px;
        padding: 6px 10px;
        gap: 5px;
    }

    .hero-badge i {
        font-size: 12px;
    }

    .hero-heading {
        font-size: clamp(22px, 3.5vw, 30px);
        gap: 8px;
    }

    .hero-description {
        font-size: 12px;
        line-height: 1.5;
    }

    .hero-cta-buttons {
        flex-direction: column;
        gap: 8px;
    }

    .btn-hero {
        width: 100%;
        padding: 11px 14px;
        font-size: 12px;
        justify-content: center;
    }

    .btn-hero i {
        font-size: 12px;
    }

    .hero-stats {
        grid-template-columns: repeat(3, 1fr);
        gap: 12px;
        padding-top: 16px;
        margin-top: 16px;
    }

    .stat-number {
        font-size: 18px;
    }

    .stat-label {
        font-size: 10px;
    }

    .hero-image-content {
        min-height: clamp(200px, 28vh, 280px);
        margin-top: 12px;
    }

    .hero-image {
        border-radius: 10px;
    }

    .hero-slider-controls {
        bottom: 12px;
        left: 12px;
        gap: 8px;
    }

    .slider-dot {
        width: 8px;
        height: 8px;
    }

    .slider-counter {
        font-size: 11px;
        margin-left: 8px;
        padding-left: 8px;
    }
}

/* =====================================
   DESKTOP (992px and above)
===================================== */

@media (min-width: 992px) {

    .hero-slide-content {
        grid-template-columns: 1fr 1fr;
    }

    .hero-text-content {
        align-items: flex-start;
    }

    .hero-badge {
        justify-content: flex-start;
    }

    .hero-heading {
        text-align: left;
    }

    .hero-description {
        text-align: left;
    }

    .hero-cta-buttons {
        justify-content: flex-start;
    }

    .hero-stats {
        justify-content: flex-start;
    }
}

/* =====================================
   LARGE SCREENS (1400px+)
===================================== */

@media (min-width: 1400px) {

    .hero-slider-section {
        min-height: 850px;
    }

    .hero-heading {
        font-size: 60px;
    }

    .hero-description {
        font-size: 18px;
        max-width: 90%;
    }

    .btn-hero {
        padding: 18px 36px;
        font-size: 16px;
    }

    .hero-image-content {
        min-height: 550px;
    }
}

        </style>

        <!-- Hero Slider Wrapper -->
        <div class="hero-slider-wrapper">
            <?php
                // Fetch hero slider data from database
                $query = "SELECT * FROM hero_slider WHERE is_active = 1 ORDER BY slide_order ASC";
                $result = $conn->query($query);
                
                $slides = [];
                if ($result && $result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        $slides[] = $row;
                    }
                } else {
                    // Fallback to sample data if table doesn't exist
                    $slides = [
                        [
                            'id' => 1,
                            'title' => 'Professional Home Cleaning',
                            'description' => 'Trusted by thousands of homeowners. Our certified cleaners deliver spotless results using eco-friendly products and modern techniques for your peace of mind.',
                            'badge' => 'Spotless Clean Guaranteed',
                            'badge_icon' => 'fa-sparkles',
                            'button_1_text' => 'Explore Services',
                            'button_1_url' => 'service.php',
                            'button_1_type' => 'primary',
                            'button_2_text' => 'Book Now',
                            'button_2_url' => 'contact.php',
                            'button_2_type' => 'secondary',
                            'stat_1_number' => 5000,
                            'stat_1_label' => 'Happy Clients',
                            'stat_2_number' => 98,
                            'stat_2_label' => '5-Star Rating',
                            'stat_3_number' => 15,
                            'stat_3_label' => 'Years Service'
                        ]
                    ];
                }
                
                // Render slides dynamically
                foreach ($slides as $index => $slide) {
                    $activeClass = $index === 0 ? 'active' : '';
                    // Use uploaded background image if available, otherwise use default
                    if (isset($slide['slide_bg_image']) && !empty($slide['slide_bg_image'])) {
                        $bgImage = 'assets/uploads/hero-slider/' . htmlspecialchars($slide['slide_bg_image']);
                    } else {
                        $bgImage = 'assets/img/bg/Gemini_Generated_Image_vdt1wsvdt1wsvdt1.png';
                    }
                    // Use uploaded hero image if available, otherwise use default
                    if (isset($slide['slide_hero_image']) && !empty($slide['slide_hero_image'])) {
                        $heroImage = 'assets/uploads/hero-slider/' . htmlspecialchars($slide['slide_hero_image']);
                    } else {
                        $heroImage = $index === 0 ? 'assets/img/hero/hero-img-1-1.png' : 'assets/img/hero/hero-img-1-2.png';
                    }
            ?>
            <!-- Dynamic Slide <?php echo $index + 1; ?> -->
            <div class="hero-slide <?php echo $activeClass; ?>" style="background-image: url('<?php echo $bgImage; ?>');" data-slide-id="<?php echo $slide['id']; ?>">
                <div class="hero-slide-content">
                    <div class="hero-text-content" style="margin-top:125px;">
                        <div class="hero-badge" >
                            <i class="fas <?php echo htmlspecialchars($slide['badge_icon']); ?>"></i>
                            <?php echo htmlspecialchars($slide['badge']); ?>
                        </div>
                        <h1 class="hero-heading">
                            <?php 
                                // Highlight last word in title
                                $titleWords = explode(' ', $slide['title']);
                                $lastWord = array_pop($titleWords);
                                echo implode(' ', $titleWords);
                                if (!empty($titleWords)) echo ' ';
                            ?>
                            <span class="highlight"><?php echo htmlspecialchars($lastWord); ?></span>
                        </h1>
                        <p class="hero-description">
                            <?php echo htmlspecialchars($slide['description']); ?>
                        </p>
                        <div class="hero-cta-buttons">
                            <?php if (!empty($slide['button_1_text'])) { ?>
                            <a href="<?php echo htmlspecialchars($slide['button_1_url']); ?>" class="btn-hero btn-<?php echo htmlspecialchars($slide['button_1_type']); ?>">
                                <?php echo htmlspecialchars($slide['button_1_text']); ?> <i class="fas fa-arrow-right"></i>
                            </a>
                            <?php } ?>
                            <?php if (!empty($slide['button_2_text'])) { ?>
                            <a href="<?php echo htmlspecialchars($slide['button_2_url']); ?>" class="btn-hero btn-<?php echo htmlspecialchars($slide['button_2_type']); ?>">
                                <?php echo htmlspecialchars($slide['button_2_text']); ?>
                            </a>
                            <?php } ?>
                        </div>
                        <div class="hero-stats">
                            <div class="stat-item">
                                <div class="stat-number"><?php echo $slide['stat_1_number']; ?><?php echo ($slide['stat_1_number'] > 100 ? '+' : ''); ?></div>
                                <div class="stat-label"><?php echo htmlspecialchars($slide['stat_1_label']); ?></div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-number"><?php echo $slide['stat_2_number']; ?>%</div>
                                <div class="stat-label"><?php echo htmlspecialchars($slide['stat_2_label']); ?></div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-number"><?php echo $slide['stat_3_number']; ?></div>
                                <div class="stat-label"><?php echo htmlspecialchars($slide['stat_3_label']); ?></div>
                            </div>
                        </div>
                    </div>
                    <div class="hero-image-content">
                        <div class="hero-image">
                            <img src="<?php echo $heroImage; ?>" alt="<?php echo htmlspecialchars($slide['title']); ?>">
                        </div>
                    </div>
                </div>
            </div>
            <?php } ?>

            <!-- Slider Controls -->
            <div class="hero-slider-controls">
                <button class="slider-nav-btn" onclick="prevSlide()" title="Previous slide">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <?php 
                    // Generate dots dynamically
                    foreach ($slides as $index => $slide) {
                        $activeClass = $index === 0 ? 'active' : '';
                        echo '<div class="slider-dot ' . $activeClass . '" onclick="changeSlide(' . $index . ')"></div>';
                    }
                ?>
                <div class="slider-counter"><span id="current-slide">1</span> / <span id="total-slides"><?php echo count($slides); ?></span></div>
                <button class="slider-nav-btn" onclick="nextSlide()" title="Next slide">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>
        </div>

        <!-- Bubbles Background -->
        <div class="bubble-bg" style="width: 200px; height: 200px; left: 5%; top: 10%;"></div>
        <div class="bubble-bg" style="width: 150px; height: 150px; left: 80%; top: 20%; animation-delay: 2s;"></div>
        <div class="bubble-bg" style="width: 100px; height: 100px; left: 15%; bottom: 15%; animation-delay: 4s;"></div>

    </section>
    <!-- Hero Slider End -->

    <script>
        let currentSlide = 0;
        const slides = document.querySelectorAll('.hero-slide');
        const totalSlides = slides.length;
        const dots = document.querySelectorAll('.slider-dot');

        function showSlide(n) {
            slides.forEach(slide => slide.classList.remove('active'));
            dots.forEach(dot => dot.classList.remove('active'));
            
            if (n >= totalSlides) n = 0;
            if (n < 0) n = totalSlides - 1;
            
            slides[n].classList.add('active');
            dots[n].classList.add('active');
            
            document.getElementById('current-slide').textContent = n + 1;
        }

        function changeSlide(n) {
            currentSlide = n;
            showSlide(currentSlide);
        }

        function nextSlide() {
            currentSlide = (currentSlide + 1) % totalSlides;
            showSlide(currentSlide);
        }

        function prevSlide() {
            currentSlide = (currentSlide - 1 + totalSlides) % totalSlides;
            showSlide(currentSlide);
        }

        // Auto-advance slides every 6 seconds
        if (totalSlides > 1) {
            setInterval(nextSlide, 6000);
        }
    </script>


        <!-- Service Area  -->
          <div class="service-layout1">
            <style>
                /* =====================================
   SERVICE LAYOUT 1 – ULTRA RESPONSIVE
===================================== */

.service-layout1 {
    margin-bottom: -210px;
    padding: clamp(48px, 8vw, 120px) 0;
    background: linear-gradient(180deg, #f8fbff, #ffffff);
}

/* FIX ROW - USE FLEX, NOT GRID */
.service-layout1 .row {
    display: flex;
    flex-wrap: wrap;
    gap: 0 !important;
    margin-left: 0 !important;
    margin-right: 0 !important;
}

/* COLUMN - FULL WIDTH */
.service-style3 {
    display: flex;
    min-height: clamp(260px, 28vw, 340px);
    flex: 0 0 100%;
    padding: 0;
}

/* DESKTOP - 4 COLUMNS */
@media (min-width: 992px) {
    .service-style3 {
        flex: 0 0 25%;
        max-width: 25%;
    }
}

/* TABLET - 2 COLUMNS */
@media (max-width: 991px) and (min-width: 768px) {
    .service-style3 {
        flex: 0 0 50%;
        max-width: 50%;
    }
}

/* MOBILE - 1 COLUMN */
@media (max-width: 767px) {
    .service-style3 {
        flex: 0 0 100%;
        max-width: 100%;
    }
}

/* CARD */
.service-content {
    position: relative;
    width: 100%;
    padding: clamp(20px, 3vw, 45px);
    background: #109c3d;
    backdrop-filter: blur(6px);
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: flex-start;
    transition: all 0.35s ease;
    border-right: 1px solid rgba(255, 255, 255, 0.15);
    overflow: hidden;
}

/* REMOVE LAST BORDER ON EACH ROW */
.service-style3:nth-child(4n) .service-content {
    border-right: none;
}

/* TABLET: REMOVE BORDER ON EVERY 2ND COLUMN */
@media (max-width: 991px) and (min-width: 768px) {
    .service-style3:nth-child(2n) .service-content {
        border-right: none;
    }

    /* ADD BOTTOM BORDER */
    .service-style3:nth-child(-n+2) .service-content {
        border-bottom: 1px solid rgba(255, 255, 255, 0.15);
    }
}

/* MOBILE: REMOVE ALL BORDERS */
@media (max-width: 767px) {
    .service-content {
        border-right: none !important;
        border-bottom: 1px solid rgba(255, 255, 255, 0.15);
    }

    .service-style3:last-child .service-content {
        border-bottom: none;
    }
}

/* ICON */
.icon-btn3 {
    margin-bottom: clamp(14px, 2vw, 22px);
    display: flex;
    justify-content: center;
    align-items: center;
    width: clamp(60px, 8vw, 90px);
    height: clamp(60px, 8vw, 90px);
    background: rgba(255, 255, 255, 0.15);
    border-radius: 50%;
    backdrop-filter: blur(10px);
}

.icon-btn3 .icon {
    display: flex;
    align-items: center;
    justify-content: center;
}

.icon-btn3 img {
    width: clamp(30px, 4vw, 48px);
    height: auto;
}

/* TITLE */
.service-title {
    font-size: clamp(16px, 1.8vw, 22px);
    font-weight: 700;
    margin-bottom: clamp(8px, 1vw, 12px);
    color: #ffffff;
    text-transform: capitalize;
}

.service-title a {
    color: #ffffff;
    text-decoration: none;
    transition: color 0.3s ease;
}

.service-title a:hover {
    color: #e0f2fe;
}

/* TEXT */
.service-text {
    font-size: clamp(13px, 1.1vw, 15px);
    line-height: 1.6;
    color: rgba(255, 255, 255, 0.85);
    max-width: 100%;
    letter-spacing: 0.3px;
}

/* BG IMAGE */
.service-bg1 {
    position: absolute;
    inset: 0;
    z-index: -1;
}

.service-bg1 img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    opacity: 0.08;
    transition: opacity 0.5s ease, transform 0.5s ease;
}

/* SHAPE */
.shape-mockup {
    max-width: 120px;
    opacity: 0.3;
    transition: opacity 0.3s ease;
}

/* HOVER */
.service-content:hover {
    transform: translateY(-6px);
    background: linear-gradient(135deg, #0f8c3d, #109c3d);
    box-shadow: inset 0 0 40px rgba(0, 0, 0, 0.2), 0 15px 40px rgba(0, 0, 0, 0.15);
}

.service-content:hover .service-bg1 img {
    opacity: 0.15;
    transform: scale(1.05);
}

.service-content:hover .icon-btn3 {
    background: rgba(255, 255, 255, 0.25);
    transform: scale(1.08);
}

.service-content:hover .icon-btn3 img {
    transform: scale(1.15);
}

.service-content:hover .shape-mockup {
    opacity: 0.5;
}

/* =====================================
   LARGE SCREENS (≥ 1400px)
===================================== */
@media (min-width: 1400px) {
    .service-layout1 {
        padding: 130px 0;
    }

    .service-style3 {
        min-height: 360px;
    }

    .service-content {
        padding: 50px;
    }
}

/* ===============================
   SCROLL REVEAL
================================ */

.reveal {
    opacity: 0;
    transform: translateY(40px);
    transition: all 0.8s ease;
}

.reveal.active {
    opacity: 1;
    transform: translateY(0);
}

            </style>
            <div class="container">
                <div class="service-inner">
                    <div class="row gx-0 wow animate__fadeInUp" data-wow-delay="0.35s">
                        <div class="col-lg-3 col-md-6 service-style3">
                            <div class="service-content border-right">
                                <div class="icon-btn3"> <span class="icon"><img src="assets/img/icon/service-icon-3-1.svg" alt="service-icon"></span></div>
                                <h2 class="service-title"><a href="service.php">window-cleaning</a></h2>
                                <p class="service-text">back and relax heall your freshly cleaned carpets upholst erolrs relaxing scent.</p>
                                <span class="shape-mockup" style="right: 0; top: 0;"><img src="assets/img/shapes/service-shape-4.png" alt="service element"></span>
                                <div class="service-bg1">
                                    <img src="assets/img/bg/service-bg2.jpg" alt="service image">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 service-style3">
                            <div class="service-content border-right">
                                <div class="icon-btn3"> <span class="icon"><img src="assets/img/icon/service-icon-3-2.svg" alt="service-icon"></span></div>
                                <h2 class="service-title"><a href="service.php">Green Cleaning all</a></h2>
                                <p class="service-text">back and relax heall your freshly cleaned carpets upholst erolrs relaxing scent.</p>
                                <span class="shape-mockup" style="right: 0; top: 0;"><img src="assets/img/shapes/service-shape-4.png" alt="service element"></span>
                                <div class="service-bg1">
                                    <img src="assets/img/bg/service-bg2.jpg" alt="service image">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 service-style3">
                            <div class="service-content border-right">
                                <div class="icon-btn3"> <span class="icon"><img src="assets/img/icon/service-icon-3-3.svg" alt="service-icon"></span></div>
                                <h2 class="service-title"><a href="service.php">Reliable Service</a></h2>
                                <p class="service-text">back and relax heall your freshly cleaned carpets upholst erolrs relaxing scent.</p>
                                <span class="shape-mockup" style="right: 0; top: 0;"><img src="assets/img/shapes/service-shape-4.png" alt="service element"></span>
                                <div class="service-bg1">
                                    <img src="assets/img/bg/service-bg2.jpg" alt="service image">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6 service-style3">
                            <div class="service-content">
                                <div class="icon-btn3"> <span class="icon"><img src="assets/img/icon/service-icon-3-4.svg" alt="service-icon"></span></div>
                                <h2 class="service-title"><a href="service.php">Safer In houses</a></h2>
                                <p class="service-text">back and relax heall your freshly cleaned carpets upholst erolrs relaxing scent.</p>
                                <span class="shape-mockup" style="right: 0; top: 0;"><img src="assets/img/shapes/service-shape-4.png" alt="service element"></span>
                                <div class="service-bg1">
                                    <img src="assets/img/bg/service-bg2.jpg" alt="service image">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <script>
const reveals = document.querySelectorAll('.service-style3');

function revealOnScroll() {
    reveals.forEach(el => {
        const top = el.getBoundingClientRect().top;
        const windowHeight = window.innerHeight;

        if (top < windowHeight - 100) {
            el.classList.add('reveal', 'active');
        }
    });
}

window.addEventListener('scroll', revealOnScroll);
revealOnScroll();
</script>

         </div> 
        <!-- Service Area  -->

        <!-- About Area  -->
        <section class="about-layout1 style3 space-bottom">
            <div class="container">
                <div class="row gx-60 g-5 justify-content-center">
                    <div class="col-xl-6">
                        <div class="img-box2 wow animate__fadeInUp" data-wow-delay="0.55s">
                            <div class="img-icon">
                                <img src="assets/img/icon/about-icon1.svg" alt="icon">
                            </div>
                            <div class="img1">
                                <a href="about.php"><img src="assets/img/about/about-img-2-1.jpg" alt="About Image"></a>
                            </div>
                            <div class="img2">
                                <a href="about.php"><img src="assets/img/about/about-img-2-2.jpg" alt="About Image"></a>
                            </div>
                            <span class="shape-mockup d-lg-block d-block h-100" style="right: 0; top: 0px;"><img src="assets/img/shapes/about-line-shape.png" alt="counter element"></span>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="about-content">
                            <div class="wow animate__fadeInUp" data-wow-delay="0.25s">
                                <div class="title-area title-anime animation-style2">
                                  <span class="sec-subtitle left-shape justify-content-center title-anime__title">ABOUT CLEANING</span>
                                  <h2 class="sec-title title-anime__title">Our Cleaning <span class="title-highlight">Agency</span> For Your City</h2>
                                </div>
                                <p class="about-text">
                                    When you work Angeles House Cleaners Referal Agency cleaning breathe easy because your home will soon
                                </p>
                            </div>
                            
                            <div class="tab-box">
                                <div class="tab-list">
                                    <h3 class="list-title">Why Choose Us</h3>
                                    <ul>
                                        <li class="list-item"><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">100 % Satisfaction Guarante</li>
                                    <li class="list-item"><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Schedule A Cleaning Time</li>
                                    <li class="list-item"><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Trained Professionals</li>
                                    <li class="list-item"><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">choose Synergy the Maids</li> 
                                    </ul>
                                                                               
                                </div>
                                <div class="tab-img">
                                    <img src="assets/img/about/about-tab-2.jpg" alt="About Image">
                                </div>
                            </div>
                            <div class="contact-box">
                                <img src="assets/img/icon/author-icon.png" alt="author image">
                                <div class="contact-content">
                                    <p class="contact-text">Call Helpline</p>
                                    <h6 class="contact-title"><a href="tel:+012325621563">+88(0) 1237 6421</a></h6>
                                </div>
                            </div>
                            <div class="about-inner mb-0 wow animate__fadeInUp" data-wow-delay="0.25s">
                                <a class="vs-btn2" href="contact.php">Book service <i class="far fa-long-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <span class="shape-mockup z-index-n1 d-lg-block d-none" style="left: 52px; top: 0px;"><img src="assets/img/shapes/about-shape-2-1.png" alt="counter element"></span>
            <span class="shape-mockup" style="right: 0; top: 0px;"><img src="assets/img/shapes/map-shape-1.png" alt="counter element"></span>
            <span class="shape-mockup z-index-n1" style="right: 120px; bottom: 50px;"><img src="assets/img/shapes/about-shape-2-2.png" alt="counter element"></span>
            <style>
                /* =====================================
   ABOUT LAYOUT 3 – FULL RESPONSIVE
===================================== */

.about-layout1.style3 {
    position: relative;
    padding: 20px;
    background: #f8fbff;
}

/* ================= IMAGE BOX ================= */

.img-box2 {
    position: relative;
    display: flex;
    justify-content: center;
    align-items: center;
}

.img-box2 img {
    width: 100%;
    border-radius: 18px;
    object-fit: cover;
}

.img-box2 .img1 {
    width: 75%;
}

.img-box2 .img2 {
    position: absolute;
    width: 50%;
    right: -30px;
    bottom: -30px;
}

.img-box2 .img-icon {
    position: absolute;
    /* top: -18px;
    left: -18px; */
    z-index: 3;
}

/* ================= CONTENT ================= */

.about-content {
    max-width: 580px;
}

.about-text {
    font-size: clamp(14px, 1.2vw, 16px);
    line-height: 1.7;
    margin-bottom: 25px;
}

/* ================= TAB BOX ================= */

.tab-box {
    display: grid;
    grid-template-columns: 1.2fr 1fr;
    gap: 25px;
    margin-bottom: 30px;
}

.tab-list {
    background: #fff;
    padding: 22px;
    border-radius: 16px;
    box-shadow: 0 15px 40px rgba(0,0,0,0.08);
}

.list-title {
    font-size: 18px;
    margin-bottom: 15px;
}

.list-item {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-bottom: 10px;
    font-size: 15px;
}

.tab-img img {
    width: 100%;
    height: 100%;
    border-radius: 16px;
    object-fit: cover;
}

/* ================= CONTACT BOX ================= */

.contact-box {
    display: flex;
    align-items: center;
    gap: 12px;
    margin-bottom: 25px;
}

.contact-title a {
    font-weight: 700;
    color: #0f172a;
}

/* ================= BUTTON ================= */

.about-inner .vs-btn2 {
    margin-top: 10px;
}

/* ================= SHAPES ================= */

.shape-mockup img {
    max-width: 100%;
}

/* ================= TABLET ================= */

@media (max-width: 991px) {

    .img-box2 {
        margin-bottom: 40px;
    }

    .img-box2 .img2 {
        right: -15px;
        bottom: -15px;
    }

    .tab-box {
        grid-template-columns: 1fr;
    }

    .about-content {
        max-width: 100%;
    }
}

/* ================= MOBILE ================= */

@media (max-width: 576px) {

    .img-box2 .img2 {
        position: static;
        width: 100%;
        margin-top: 20px;
    }

    .img-box2 .img1 {
        width: 100%;
    }

    .img-box2 .img-icon {
        top: -10px;
        left: -10px;
    }

    .tab-list,
    .tab-img {
        text-align: center;
    }

    .list-item {
        justify-content: center;
    }

    .contact-box {
        flex-direction: column;
        text-align: center;
    }
}

            </style>
         </section>
        <!-- About Area End -->

        <!-- Service Area  -->
         <section class="service-layout3 space position-relative">
            <style>
                /* SERVICE LAYOUT 3 – RESPONSIVE DYNAMIC */
                .service-layout3 {
                    position: relative;
                    padding-top:80px;
                    background-size: cover;
                    background-position: center;
                    background-repeat: no-repeat;
                }

                .service-layout3::before {
                    content: "";
                    position: absolute;
                    inset: 0;
                    background: linear-gradient(180deg, rgba(5, 10, 25, 0.78), rgba(5, 10, 25, 0.85));
                    z-index: 0;
                }

                .service-layout3 .container {
                    position: relative;
                    z-index: 1;
                    margin-top: -62px;
                }

                .service-layout3 .row.justify-content-between {
                    row-gap: 25px;
                    margin-bottom: clamp(30px, 4vw, 55px);
                }

                .service-layout3 .sec-subtitle {
                    color: #93c5fd;
                    letter-spacing: 1.5px;
                    font-size: 13px;
                }

                .service-layout3 .sec-title {
                    font-size: clamp(26px, 3vw, 40px);
                    line-height: 1.15;
                }

                .arraw-style1 {
                    display: flex;
                    align-items: center;
                }

                .custom-arraw {
                    display: flex;
                    gap: 12px;
                }

                .icon-btn2 {
                    width: 48px;
                    height: 48px;
                    border-radius: 50%;
                    background: rgba(255,255,255,0.12);
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    transition: all 0.3s ease;
                    cursor: pointer;
                }

                .icon-btn2:hover {
                    background: rgba(255,255,255,0.25);
                    transform: scale(1.05);
                }

                @media (max-width: 767px) {
                    .arraw-style1 {
                        justify-content: center;
                    }
                }

                .service-slider {
                    display: grid;
                    grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
                    gap: clamp(18px, 2.5vw, 34px);
                    margin-top: -49px;
                }

                .service-style4 {
                    height: 100%;
                    display: flex;
                    flex-direction: column;
                    background: rgba(255,255,255,0.06);
                    backdrop-filter: blur(10px);
                    border-radius: 22px;
                    overflow: hidden;
                    transition: transform 0.35s ease, box-shadow 0.35s ease;
                }

                .service-style4:hover {
                    transform: translateY(-10px);
                    box-shadow: 0 35px 80px rgba(0,0,0,0.45);
                }

                .service-img {
                    position: relative;
                    overflow: hidden;
                    height: 220px;
                }

                .service-img img {
                    width: 100%;
                    height: 100%;
                    object-fit: cover;
                    transition: transform 0.6s ease;
                }

                .service-style4:hover .service-img img {
                    transform: scale(1.1);
                }

                .service-icon {
                    position: absolute;
                    top: 16px;
                    left: 50%;
                    transform: translateX(-50%);
                    display: flex;
                    justify-content: center;
                    z-index: 2;
                }

                .icon-btn3 {
                    background: #ffffff;
                    border-radius: 50%;
                    padding: 0px;
                    box-shadow: 0 12px 30px rgba(0,0,0,0.25);
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    font-size: 20px;
                    color: #109c3d;
                }

                .service-body {
                    position: relative;
                    padding: clamp(18px, 2.2vw, 28px);
                    display: flex;
                    flex-direction: column;
                    gap: 10px;
                    flex-grow: 1;
                }

                .service-title a {
                    color: #ffffff;
                    font-size: clamp(17px, 1.6vw, 19px);
                    font-weight: 700;
                    text-decoration: none;
                    text-transform: capitalize;
                    transition: color 0.3s ease;
                }

                .service-title a:hover {
                    color: #93c5fd;
                }

                .service-text {
                    color: #c7d2fe;
                    font-size: clamp(14px, 1.1vw, 15px);
                    line-height: 1.6;
                }

                .service-loading {
                    text-align: center;
                    color: #93c5fd;
                    padding: 40px;
                }

                @media (max-width: 576px) {
                    .service-style4 {
                        text-align: center;
                    }

                    .service-icon {
                        left: 50%;
                    }

                    .service-body {
                        align-items: center;
                    }

                    .service-slider {
                        grid-template-columns: 1fr;
                    }
                }

                @media (min-width: 1400px) {
                    .service-slider {
                        gap: 40px;
                    }
                }

                /* Slick Slider Customization */
                .service-slider.slick-initialized {
                    display: flex;
                    grid-template-columns: unset;
                }

                .service-slider .slick-slide {
                    display: flex;
                    align-items: stretch;
                }

                .service-slider .slick-slide > div {
                    width: 100%;
                }
            </style>
            <div class="container">
                <div class="row justify-content-between position-relative align-items-center">
                    <div class="col-lg-6 col">
                        <div class="title-area text-left wow animate__fadeInUp title-anime animation-style5" data-wow-delay="0.25s">
                            <span class="sec-subtitle left-shape justify-content-center title-anime__title">CLEANING SERVICE</span>
                            <h2 class="sec-title title-anime__title text-white">Our Excellent Service</h2>
                        </div>
                    </div>
                    <div class="col-lg-6 col-auto">
                        <div class="arraw-style1">
                            <div class="custom-arraw wow animate__fadeInUp" data-wow-delay="0.45s">
                                <div class="icon-arraw slick-prev" data-slick-prev=".service-slider">
                                    <button class="icon-btn2" type="button">
                                        <i class="fa-solid fa-chevron-left" style="color: white;"></i>
                                    </button>
                                </div>
                                <div class="icon-arraw slick-next" data-slick-next=".service-slider">
                                    <button class="icon-btn2" type="button">
                                        <i class="fa-solid fa-chevron-right" style="color: white;"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="service-slider" id="serviceSlider">
                    <div class="service-loading"><i class="fas fa-spinner fa-spin"></i> Loading services...</div>
                </div>
            </div>
            <div class="common-line shape-mockup d-none d-xxl-block" style="top: -7px;">
                <img src="assets/img/shapes/line-shep.png" alt="shapes">
            </div>
         </section>

         <script>
            // Load Services Dynamically
            function loadHomeServices() {
                fetch('api_handler.php?action=get_services')
                    .then(response => response.json())
                    .then(data => {
                        if (data.success && data.data) {
                            renderServices(data.data);
                        } else {
                            document.getElementById('serviceSlider').innerHTML = '<p style="color: #c7d2fe; text-align: center;">No services available</p>';
                        }
                    })
                    .catch(error => {
                        console.error('Error loading services:', error);
                        document.getElementById('serviceSlider').innerHTML = '<p style="color: #ef4444; text-align: center;">Error loading services</p>';
                    });
            }

            function renderServices(services) {
                let html = '';

                services.forEach((service, index) => {
                    const imageUrl = service.image ? service.image : 'assets/img/service/default-service.jpg';
                    
                    html += `
                        <div class="service-card-wrapper">
                            <div class="service-style4">
                                <div class="service-img">
                                    <a href="service-details.php?id=${service.id}">
                                        <img src="${imageUrl}" alt="${service.name}" class="w-100">
                                    </a>
                                </div>
                                <div class="service-body">
                                    <div class="service-content">
                                        <h2 class="service-title"><a href="service-details.php?id=${service.id}">${service.name}</a></h2>
                                        <p class="service-text">${service.description || 'Professional cleaning service for your needs'}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    `;
                });

                const slider = document.getElementById('serviceSlider');
                slider.innerHTML = html;

                // Initialize or reinitialize Slick slider
                if (jQuery('.service-slider').hasClass('slick-initialized')) {
                    jQuery('.service-slider').slick('unslick');
                }

                jQuery('.service-slider').slick({
                    infinite: true,
                    slidesToShow: 4,
                    slidesToScroll: 1,
                    dots: false,
                    arrows: true,
                    autoplay: true,
                    autoplaySpeed: 3000,
                    prevArrow: '.service-slider-prev',
                    nextArrow: '.service-slider-next',
                    responsive: [
                        {
                            breakpoint: 1200,
                            settings: {
                                slidesToShow: 3,
                                slidesToScroll: 1
                            }
                        },
                        {
                            breakpoint: 768,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1
                            }
                        },
                        {
                            breakpoint: 576,
                            settings: {
                                slidesToShow: 1,
                                slidesToScroll: 1
                            }
                        }
                    ]
                });
            }

            // Load on page load
            document.addEventListener('DOMContentLoaded', function() {
                loadHomeServices();
                // Reload every 60 seconds to reflect admin changes
                setInterval(loadHomeServices, 60000);
            });
         </script>
        <!-- Service Area End  -->

        <!-- Book Area -->
        <section class="testi-layout3 space position-relative ">
            <style>
                /* =====================================
   TESTIMONIAL LAYOUT 3 – RESPONSIVE
===================================== */

.testi-layout3 {
    position: relative;
    padding-top:80px;
    overflow: hidden;
}

/* BACKGROUND IMAGE */
.testi-bg img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* MAIN ROW */
.testi-layout3 .row {
    row-gap: clamp(30px, 5vw, 60px);
}

/* =====================================
   VIDEO BOX
===================================== */

.video-box {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 18px;
}

.video-title {
    font-size: clamp(18px, 1.6vw, 22px);
    font-weight: 700;
}

.play-btn {
    width: 72px;
    height: 72px;
    background: #4facfe;
    color: #fff;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
    box-shadow: 0 18px 40px rgba(79,172,254,0.45);
    transition: transform 0.3s ease;
}

.play-btn:hover {
    transform: scale(1.1);
}

/* =====================================
   TESTIMONIAL BODY
===================================== */

.testi-body {
    position: relative;
    display: flex;
    flex-direction: column;
    gap: 25px;
}

/* TITLE + ARROWS */
.title-inner {
    display: flex;
    justify-content: space-between;
    align-items: flex-end;
    gap: 20px;
    flex-wrap: wrap;
}

.testi-layout3 .sec-title {
    font-size: clamp(24px, 3vw, 38px);
    line-height: 1.2;
}

/* ARROWS */
.custom-arraw {
    display: flex;
    gap: 0px;
}

.icon-btn2 {
    width: 46px;
    height: 46px;
    border-radius: 50%;
    background: rgba(0,0,0,0.08);
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
}

.icon-btn2:hover {
    background: rgba(0,0,0,0.15);
    transform: scale(1.05);
}

/* =====================================
   TESTIMONIAL CARD
===================================== */

.testi-content {
    background: #ffffff;
    border-radius: 22px;
    padding: clamp(20px, 2.5vw, 35px);
    box-shadow: 0 25px 60px rgba(0,0,0,0.08);
    display: flex;
    flex-direction: column;
    gap: 18px;
}

/* TEXT */
.testi-text {
    font-size: clamp(14px, 1.2vw, 16px);
    line-height: 1.7;
    color: #475569;
}

/* AUTHOR */
.vs-testi__top {
    display: flex;
    align-items: center;
    gap: 12px;
}

.vs-testi__image img {
    width: 55px;
    height: 55px;
    border-radius: 50%;
    object-fit: cover;
}

.vs-testi__title {
    font-size: 16px;
    font-weight: 700;
}

.star-rating i {
    color: #facc15;
    font-size: 14px;
}

/* QUOTE */
.quote-icon {
    margin-left: auto;
    font-size: 28px;
    color: #4facfe;
}

/* =====================================
   MOBILE
===================================== */

@media (max-width: 576px) {

    .video-box {
        text-align: center;
    }

    .title-inner {
        justify-content: center;
        text-align: center;
    }

    .custom-arraw {
        justify-content: center;
    }

    .testi-content {
        text-align: center;
    }

    .vs-testi__top {
        justify-content: center;
    }

    .quote-icon {
        display: none;
    }
}

/* =====================================
   LARGE SCREENS
===================================== */

@media (min-width: 1400px) {
    .testi-layout3 {
        padding: 140px 0;
        padding-bottom: 20px;
    }
}

            </style>
            <div class="container" style="margin-top: -66px;">
                <div class="row gx-60 z-index position-relative justify-content-center align-items-center">
                    
                    <div class="col-lg-7">
                        <div class="testi-body">
                            <div class="title-inner">
                                <div class="title-area text-left wow animate__fadeInUp title-anime animation-style5" data-wow-delay="0.25s">
                                    <span class="sec-subtitle  left-shape justify-content-center title-anime__title">TESTIMONIAL</span>
                                    <h2 class="sec-title title-anime__title">Our Client Are <span class="title-highlight">Saying</span> About us</h2>
                                </div>
                                <div class="arraw-style1">
                                    <div class="custom-arraw wow animate__fadeInUp" data-wow-delay="0.45s">
                                        <div class="icon-arraw slick-prev" data-slick-prev=".testi-slider2">
                                            <button class="icon-btn2">
                                                <img src="assets/img/icon/arraw-left.svg" alt="icon">
                                            </button>
                                        </div>
                                        <div class="icon-arraw slick-next" data-slick-next=".testi-slider2">
                                            <button class="icon-btn2">
                                                <img src="assets/img/icon/arraw-right.svg" alt="icon">
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="testi-items wow animate__fadeInUp" data-wow-delay="0.35s">
                                <div class="vs-carousel testi-slider2" id="testimonialsContainer" data-fade="true">
                                    <!-- Testimonials will be loaded dynamically here -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="testi-shape">
                <span class="testi-bg">
                    <img src="assets/img/bg/book-bg-1-2.jpg" alt="testi element">
                </span>
            </div>
            <span class="shape-mockup d-xl-block d-none wow animate__fadeInLeft" style="right: 0px; top: 60px;"><img src="assets/img/shapes/map-shape-2.png" alt="Book element"></span>
            <span class="shape-mockup z-index custom-sheap wow animate__fadeInRight" data-wow-delay="0.90s" style="right: 0px; bottom: 80px;"><img src="assets/img/shapes/service-shape-man2.png" alt="service element"></span>
        </section>
        <!-- Book Area End  -->


         <!-- Counter Area -->
        <div class="counter-layout2 position-relative">
            <style>
                /* =====================================
   COUNTER LAYOUT 2 – RESPONSIVE
===================================== */

.counter-layout2 {
    position: relative;
    padding: 0px;
    overflow: hidden;
    background: #f8fbff;
}

/* INNER WRAP */
.counter-style1 {
    position: relative;
    z-index: 2;
}

/* GRID ROW */
.counter-layout2 .row {
    row-gap:0px;
}

/* COUNTER CARD */
.media-style {
    width: 100%;
    height: 100%;
}

.media-inner {
    display: flex;
    align-items: center;
    gap: clamp(14px, 2vw, 20px);
    padding: clamp(18px, 2.5vw, 28px);
    background:black;
    border-radius: 20px;
    box-shadow: 0 20px 45px rgba(0,0,0,0.08);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

/* HOVER */
.media-inner:hover {
    transform: translateY(-8px);
    box-shadow: 0 30px 65px rgba(0,0,0,0.12);
}

/* ICON */
.counter-icon img {
    width: clamp(42px, 4vw, 56px);
    height: auto;
}

/* NUMBER */
.media-title {
    font-size: clamp(22px, 2.6vw, 34px);
    font-weight: 800;
    color: #0f172a;
}

/* SUFFIX */
.count-icon {
    font-size: clamp(16px, 1.6vw, 20px);
    font-weight: 700;
    margin-left: 4px;
    color: #4facfe;
}

/* LABEL */
.media-text {
    font-size: clamp(14px, 1.2vw, 15px);
    color: #64748b;
    margin-top: 4px;
}

/* =====================================
   MOBILE
===================================== */
@media (max-width: 576px) {

    .media-inner {
        flex-direction: column;
        text-align: center;
    }

    .media-counter {
        align-items: center;
    }
}

/* =====================================
   LARGE SCREENS
===================================== */
@media (min-width: 1400px) {
    .counter-layout2 {
        padding: 140px 0;
    }
}
@media (min-width: 1200px) {
    .counter-layout2 .row {
        display: grid !important;
        grid-template-columns: repeat(4, 1fr);
        gap: 24px;
    }

    .counter-layout2 .row > [class*="col-"] {
        width: 100% !important;
        max-width: 100% !important;
    }
}

            </style>
            <div class="counter-style1">
                <div class="container">
                    <div class="row g-4 z-index-common justify-content-lg-between justify-content-center align-items-center ">
                        <div class="col-xl-auto col-lg-6 col-6">
                            <div class="media-style">
                                <div class="media-inner">
                                    <div class="counter-icon">
                                        <span class="icon"><img src="assets/img/icon/counter-icon-2-1.png" alt="icon"></span>
                                    </div>
                                    <div class="media-counter">
                                        <div class="media-count">
                                            <h2 class="media-title h3 counter-number" data-count="35">00</h2>
                                            <span class="count-icon">K</span>
                                        </div>
                                        <p class="media-text">Quality Services</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-auto col-lg-6 col-6">
                            <div class="media-style">
                                <div class="media-inner">
                                    <div class="counter-icon">
                                        <span class="icon"><img src="assets/img/icon/counter-icon-2-2.png" alt="icon"></span>
                                    </div>
                                    <div class="media-counter">
                                        <div class="media-count">
                                            <h2 class="media-title h3 counter-number" data-count="12">00</h2>
                                            <span class="count-icon">+</span>
                                        </div>
                                        <p class="media-text">year experience</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-auto col-lg-6 col-6">
                            <div class="media-style">
                                <div class="media-inner">
                                    <div class="counter-icon">
                                        <span class="icon"><img src="assets/img/icon/counter-icon-2-3.png" alt="icon"></span>
                                    </div>
                                    <div class="media-counter">
                                        <div class="media-count">
                                            <h2 class="media-title h3 counter-number" data-count="99">00</h2>
                                            <span class="count-icon">%</span>
                                        </div>
                                        <p class="media-text">Success Rate</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-auto col-lg-6 col-6">
                            <div class="media-style">
                                <div class="media-inner">
                                    <div class="counter-icon">
                                        <span class="icon"><img src="assets/img/icon/counter-icon-2-4.png" alt="icon"></span>
                                    </div>
                                    <div class="media-counter">
                                        <div class="media-count">
                                            <h2 class="media-title h3 counter-number" data-count="100">00</h2>
                                            <!-- <span class="count-icon">+</span> -->
                                        </div>
                                        <p class="media-text">Awards Winning</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <span class="shape-mockup" style="left: 0; top: 0px;"><img src="assets/img/shapes/counter-shape-3-1.png" alt="counter element"></span>
            <span class="shape-mockup" style="right: 0; top: 0px;"><img src="assets/img/shapes/counter-shape-3-2.png" alt="counter element"></span>
        </div>
        <!-- Counter Area End -->
        <!--==============================


        Price Area
        ============================== -->
        <section class="package-layout1 space">
            <style>
                /* =====================================
   PRICING – UNIQUE ATTRACTIVE DESIGN
===================================== */

.package-layout1 {
    position: relative;
    padding-top:90px;
    padding-bottom:20px;
    background-size: cover;
    background-position: center;
    overflow: hidden;
}

/* DARK GRADIENT OVERLAY */
.package-layout1::before {
    content: "";
    position: absolute;
    inset: 0;
    background: radial-gradient(
        circle at top,
        rgba(79,172,254,0.35),
        rgba(5,10,30,0.9)
    );
    z-index: 0;
}

.package-layout1 .container {
    position: relative;
    z-index: 1;
    margin-top: -77px;
}

/* =====================================
   GRID – CLEAN & BALANCED
===================================== */

.package-layout1 .row.g-5 {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(290px, 1fr));
    gap: clamp(22px, 3vw, 45px);
}

.package-layout1 .row.g-5 > [class*="col-"] {
    width: 100%;
    max-width: 100%;
}

/* =====================================
   CARD – PREMIUM LOOK
===================================== */

.package-style1 {
    height: 100%;
    display: flex;
    flex-direction: column;
    background: linear-gradient(
        180deg,
        #ffffff,
        #f9fbff
    );
    border-radius: 28px;
    position: relative;
    box-shadow:
        0 10px 30px rgba(0,0,0,0.15),
        inset 0 0 0 1px rgba(255,255,255,0.6);
    transition: transform 0.4s ease, box-shadow 0.4s ease;
}

/* CARD GLOW */
.package-style1::after {
    content: "";
    position: absolute;
    inset: -2px;
    border-radius: inherit;
    background: linear-gradient(
        120deg,
        transparent,
        rgba(79,172,254,0.6),
        transparent
    );
    opacity: 0;
    transition: opacity 0.4s ease;
    pointer-events: none;
}

.package-style1:hover::after {
    opacity: 1;
}

/* LIFT ON HOVER */
.package-style1:hover {
    transform: translateY(-14px) scale(1.02);
    box-shadow: 0 45px 100px rgba(0,0,0,0.25);
}

/* =====================================
   HEADER
===================================== */

.package-top {
    padding: clamp(24px, 3vw, 34px);
    border-bottom: 1px solid rgba(0,0,0,0.08);
}

.package-name {
    font-size: clamp(18px, 1.8vw, 22px);
    font-weight: 800;
    letter-spacing: 0.3px;
    text-transform: capitalize;
}

.package-text {
    font-size: 14px;
    color: #64748b;
}

/* =====================================
   PRICE – VISUAL FOCUS
===================================== */

.package-price {
    margin-top: 14px;
    font-size: clamp(36px, 3.5vw, 46px);
    font-weight: 900;
    color: #0f172a;
    position: relative;
}

.package-price::after {
    content: "";
    position: absolute;
    left: 0;
    bottom: -8px;
    width: 42px;
    height: 4px;
    border-radius: 10px;
    background: linear-gradient(90deg, #4facfe, #00f2fe);
}

/* =====================================
   BODY
===================================== */

.package-body {
    padding: 0px;
    flex: 1;
}

.list-style1 li {
    font-size: 15px;
    line-height: 1.6;
    margin-bottom: 12px;
    display: flex;
    align-items: flex-start;
    gap: 10px;
}

/* =====================================
   FOOTER
===================================== */

.package-bottom {
    padding: 22px 30px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.save-price {
    font-weight: 700;
    color: #16a34a;
}

/* CTA BUTTON */
.price-btn {
    padding: 26px;
}

.price-btn .vs-btn2 {
    width: 100%;
    font-size: 16px;
    padding: 5px;
    border-radius: 14px;
    background: linear-gradient(135deg, #4facfe, #00f2fe);
    box-shadow: 0 15px 35px rgba(79,172,254,0.45);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.price-btn .vs-btn2:hover {
    transform: translateY(-2px);
    box-shadow: 0 25px 50px rgba(79,172,254,0.6);
}

/* =====================================
   MOBILE POLISH
===================================== */

@media (max-width: 576px) {

    .package-style1 {
        text-align: center;
    }

    .package-inner,
    .package-bottom {
        flex-direction: column;
        gap: 12px;
    }

    .package-price::after {
        left: 50%;
        transform: translateX(-50%);
    }
}

/* =====================================
   ULTRA WIDE SCREENS
===================================== */

@media (min-width: 1600px) {
    .package-layout1 {
        padding: 180px 0;
    }
}

            </style>
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-6">
                        <div class="title-area text-center wow animate__fadeInUp title-anime animation-style5" data-wow-delay="0.25s">
                            <span class="sec-subtitle justify-content-center title-anime__title">OUR PRICING</span>
                            <h2 class="sec-title title-anime__title text-white">Choose Your Pricing</h2>
                        </div>
                    </div>
                </div>              
                <div class="row g-5">
                    <div class="col-xl-4 col-md-6 wow animate__fadeInUp" data-wow-delay="0.25s">
                        <div class="package-wraper">
                            <div class="package-style1">
                                <div class="package-top">
                                    <div class="package-inner">
                                        <div class="title-area">
                                            <h3 class="package-name">home plan</h3>
                                            <p class="package-text">starter plan</p>
                                        </div>
                                        <div class="package-icon">
                                            <div class="icon-btn3"> <span class="icon"><img src="assets/img/icon/service-icon-3-2.svg" alt="service-icon"></span></div>
                                        </div>
                                    </div>
                                    <p class="package-price"><i class="fa-light fa-dollar-sign"></i>29<span class="duration">/month</span></p>
                                </div>
                                <div class="package-body">                                   
                                    <div class="list-style1">
                                        <ul class="list-unstyled mb-0">
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">100 % Satisfaction Guarante</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Clean all mirrors</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Dining & Living Room</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">cleaning  your home will soon</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Bed & Mattress Cleaning</li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="package-bottom">
                                    <span class="save-price">save <strong>$20</strong></span>
                                    <div class="star-rating">
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                    </div>
                                </div>
                                <div class="price-btn">
                                    <a class="vs-btn2" href="contact.php">Book Now<i class="far fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-md-6 wow animate__fadeInUp" data-wow-delay="0.45s">
                        <div class="package-wraper">
                            <div class="package-style1">
                                <div class="package-top">
                                    <div class="package-inner">
                                        <div class="title-area">
                                            <h3 class="package-name">office plan</h3>
                                            <p class="package-text">home service</p>
                                        </div>
                                        <div class="package-icon">
                                            <div class="icon-btn3"> <span class="icon"><img src="assets/img/icon/service-icon-2-5.svg" alt="service-icon"></span></div>
                                        </div>
                                    </div>
                                    <p class="package-price"><i class="fa-light fa-dollar-sign"></i>45<span class="duration">/month</span></p>
                                </div>
                                <div class="package-body">                                   
                                    <div class="list-style1">
                                        <ul class="list-unstyled mb-0">
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">100 % Satisfaction Guarante</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Clean all mirrors</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Dining & Living Room</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">cleaning  your home will soon</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Bed & Mattress Cleaning</li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="package-bottom">
                                    <span class="save-price">save <strong>$20</strong></span>
                                    <div class="star-rating">
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                    </div>
                                </div>
                                <div class="price-btn">
                                    <a class="vs-btn2" href="contact.php">Book Now<i class="far fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-md-6 wow animate__fadeInUp" data-wow-delay="0.65s">
                        <div class="package-wraper">
                            <div class="package-style1">
                                <div class="package-top">
                                    <div class="package-inner">
                                        <div class="title-area">
                                            <h3 class="package-name">apartment plan</h3>
                                            <p class="package-text">home service</p>
                                        </div>
                                        <div class="package-icon">
                                            <div class="icon-btn3"> <span class="icon"><img src="assets/img/icon/service-icon-2-6.svg" alt="service-icon"></span></div>
                                        </div>
                                    </div>
                                    <p class="package-price"><i class="fa-light fa-dollar-sign"></i>55<span class="duration">/month</span></p>
                                </div>
                                <div class="package-body">                                   
                                    <div class="list-style1">
                                        <ul class="list-unstyled mb-0">
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">100 % Satisfaction Guarante</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Clean all mirrors</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Dining & Living Room</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">cleaning  your home will soon</li>
                                            <li><img src="assets/img/icon/right-mark-icon2.svg" alt="icon" class="icon">Bed & Mattress Cleaning</li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="package-bottom">
                                    <span class="save-price">save <strong>$20</strong></span>
                                    <div class="star-rating">
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                    </div>
                                </div>
                                <div class="price-btn">
                                    <a class="vs-btn2" href="contact.php">Book Now<i class="far fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="common-line shape-mockup d-none d-lg-block" style="top: -9px;">
                <img src="assets/img/shapes/line-shep.png" alt="shapes">
            </div>
        </section>


        <!-- Blog Area -->
          <section class="vs-blog__layout1 space">
            <style>
                .blog-slider {
                    position: relative;
                    margin-top: 0px;
                }
                
                .blog-card-wrapper {
                    padding: 15px;
                }

                .vs-blog__style1 {
                    height: 100%;
                    background: white;
                    border-radius: 12px;
                    overflow: hidden;
                    box-shadow: 0 8px 24px rgba(0,0,0,0.08);
                    transition: transform 0.3s, box-shadow 0.3s;
                    display: flex;
                    flex-direction: column;
                }

                .vs-blog__style1:hover {
                    transform: translateY(-8px);
                    box-shadow: 0 12px 32px rgba(0,0,0,0.15);
                }

                .blog-img {
                    position: relative;
                    overflow: hidden;
                    width: 100%;
                    height: 220px;
                    margin-bottom: 15px;
                }

                .blog-img img {
                    width: 100%;
                    height: 100%;
                    object-fit: cover;
                    transition: transform 0.4s;
                }

                .vs-blog__style1:hover .blog-img img {
                    transform: scale(1.08);
                }

                .blog-cate {
                    position: absolute;
                    bottom: 10px;
                    left: 10px;
                    background: linear-gradient(135deg,#4facfe,#00f2fe);
                    color: white;
                    font-size: 11px;
                    padding: 5px 10px;
                    border-radius: 4px;
                    font-weight: 600;
                    text-transform: capitalize;
                }

                .blog-content {
                    padding: 15px;
                    display: flex;
                    flex-direction: column;
                    flex-grow: 1;
                    gap: 10px;
                }

                .blog-inner-author {
                    font-size: 12px;
                    color: #666;
                }

                .blog-inner-author a {
                    color: #666;
                    text-decoration: none;
                }

                .blog-title {
                    margin: 0;
                    flex-grow: 1;
                }

                .blog-title a {
                    font-size: 16px;
                    font-weight: 700;
                    color: #0f172a;
                    text-decoration: none;
                    transition: color 0.3s;
                    line-height: 1.4;
                }

                .blog-title a:hover {
                    color: #4facfe;
                }

                .blog-btn {
                    margin-top: auto;
                }

                .link-btn {
                    display: inline-flex;
                    align-items: center;
                    gap: 8px;
                    color: #4facfe;
                    text-decoration: none;
                    font-weight: 600;
                    font-size: 13px;
                    transition: color 0.3s;
                }

                .link-btn:hover {
                    color: #0f9fd5;
                }

                .link-btn .icon {
                    width: 28px;
                    height: 28px;
                    background: rgba(79, 172, 254, 0.1);
                    border-radius: 50%;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    transition: background 0.3s;
                    font-size: 12px;
                }

                .link-btn:hover .icon {
                    background: rgba(79, 172, 254, 0.2);
                }

                .blog-slider .slick-slide {
                    height: auto;
                }

                .blog-slider .slick-arrow {
                    position: absolute;
                    top: -45px;
                    width: 40px;
                    height: 40px;
                    background: rgba(79, 172, 254, 0.1);
                    border: none;
                    color: #4facfe;
                    font-size: 16px;
                    cursor: pointer;
                    border-radius: 50%;
                    transition: all 0.3s;
                    z-index: 10;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                }

                .blog-slider .slick-arrow:hover {
                    background: #4facfe;
                    color: white;
                }

                .blog-slider .slick-prev {
                    right: 50px;
                }

                .blog-slider .slick-next {
                    right: 0;
                }

                @media (max-width: 768px) {
                    .blog-img {
                        height: 180px;
                    }
                    
                    .blog-content {
                        padding: 12px;
                    }
                    
                    .blog-slider .slick-arrow {
                        top: -40px;
                        width: 35px;
                        height: 35px;
                        font-size: 14px;
                    }
                    
                    .blog-slider .slick-prev {
                        right: 40px;
                    }
                }

                @media (max-width: 576px) {
                    .blog-card-wrapper {
                        padding: 10px;
                    }

                    .blog-img {
                        height: 160px;
                    }

                    .blog-title a {
                        font-size: 14px;
                    }
                }
            </style>
            <div class="container" style="margin-top: 0px;">
                <div class="row justify-content-center">
                    <div class="col-lg-6">
                        <div class="title-area text-center wow animate__fadeInUp title-anime animation-style5" data-wow-delay="0.25s">
                            <span class="sec-subtitle justify-content-center title-anime__title">OUR UPDATE BLOG</span>
                            <h2 class="sec-title title-anime__title">Updated Latest News</h2>
                        </div>
                    </div>
                </div>
                <div class="blog-slider" id="blogSlider" data-slide-show="3" data-ml-slide-show="2" data-lg-slide-show="2" data-md-slide-show="1" data-autoplay="true" data-arrows="true">
                    <div class="blog-loading"><i class="fas fa-spinner fa-spin"></i> Loading blog posts...</div>
                </div>
            </div>
          </section>
        <!-- Blog Area End  -->

        <script>
            function loadBlogPosts() {
                fetch('api_handler.php?action=get_blog_posts')
                    .then(response => response.json())
                    .then(data => {
                        if (data.success && data.data && data.data.length > 0) {
                            renderBlogPosts(data.data);
                        }
                    })
                    .catch(error => console.error('Error:', error));
            }

            function renderBlogPosts(posts) {
                let html = '';
                posts.forEach(post => {
                    const imageUrl = post.featured_image || 'assets/img/blog/blog-s-1-1.jpg';
                    const createdDate = new Date(post.created_at).toLocaleDateString();
                    const category = post.category || 'General';
                    html += `
                        <div class="blog-card-wrapper">
                            <div class="vs-blog__style1">
                                <div class="blog-img">
                                    <a href="blog-details.php?id=${post.id}">
                                        <img src="${imageUrl}" alt="${post.title}" style="width: 100%; height: 100%; object-fit: cover;">
                                    </a>
                                    <a href="blog.php?category=${category}" class="blog-cate">${category}</a>
                                </div>
                                <div class="blog-content">
                                    <div class="blog-inner-author">
                                        <a href="blog.php"><i class="fa-regular fa-calendar-days"></i>${createdDate}</a>
                                    </div>
                                    <h2 class="blog-title"><a href="blog-details.php?id=${post.id}">${post.title}</a></h2>
                                    <div class="blog-btn">
                                        <a class="link-btn" href="blog-details.php?id=${post.id}">
                                            <span>Read More</span>
                                            <span class="icon"><i class="fa-solid fa-arrow-right"></i></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    `;
                });
                document.getElementById('blogSlider').innerHTML = html;
                if (jQuery('.blog-slider').hasClass('slick-initialized')) {
                    jQuery('.blog-slider').slick('unslick');
                }
                jQuery('.blog-slider').slick({
                    infinite: true,
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    autoplay: true,
                    autoplaySpeed: 4000,
                    prevArrow: '<button class="slick-prev" style="position: absolute; top: 220px; right: 50px; width: 40px; height: 40px; background: rgb(17 19 20 / 82%); border: none; color: #4facfe; font-size: 16px; cursor: pointer; border-radius: 50%; transition: all 0.3s; z-index: 10; display: flex; align-items: center; justify-content: center;"><svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="15 18 9 12 15 6"></polyline></svg></button>',
                    nextArrow: '<button class="slick-next" style="position: absolute; top: 220px; right: 0; width: 40px; height: 40px; background: rgb(17 19 20 / 82%); border: none; color: #4facfe; font-size: 16px; cursor: pointer; border-radius: 50%; transition: all 0.3s; z-index: 10; display: flex; align-items: center; justify-content: center;"><svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="9 18 15 12 9 6"></polyline></svg></button>',
                    responsive: [{breakpoint: 1200, settings: {slidesToShow: 2}}, {breakpoint: 768, settings: {slidesToShow: 1}}]
                });
            }
            document.addEventListener('DOMContentLoaded', function() {
                loadBlogPosts();
                setInterval(loadBlogPosts, 60000);
            });
        </script>
                                      
        <!-- Blog Area End  -->

        <!-- Testimonials Loading Script -->
        <script>
            function loadTestimonials() {
                fetch('api_handler.php?action=get_approved_reviews')
                    .then(response => response.json())
                    .then(data => {
                        console.log('Testimonials API Response:', data);
                        if (data.success) {
                            if (data.data && data.data.length > 0) {
                                renderTestimonials(data.data);
                            } else {
                                console.log('No approved reviews found');
                                document.getElementById('testimonialsContainer').innerHTML = '<p style="text-align: center; padding: 40px; color: #999;">No testimonials available yet</p>';
                            }
                        } else {
                            console.error('API Error:', data.message);
                        }
                    })
                    .catch(error => {
                        console.error('Error loading testimonials:', error);
                        document.getElementById('testimonialsContainer').innerHTML = '<p style="text-align: center; padding: 40px; color: #f00;">Error loading testimonials</p>';
                    });
            }

            function renderTestimonials(reviews) {
                const container = document.getElementById('testimonialsContainer');
                
                // Create star rating string
                function getStarRating(rating) {
                    let stars = '';
                    const ratingNum = parseInt(rating) || 5;
                    for (let i = 0; i < ratingNum; i++) {
                        stars += '<i class="fa-solid fa-star"></i>';
                    }
                    return stars;
                }

                let html = '';
                reviews.forEach(review => {
                    html += `
                        <div class="testi-content">
                            <div class="vs-testi__top">
                                <div class="vs-testi__author">
                                    <h3 class="vs-testi__title">${review.customer_name || 'Customer'}</h3>
                                    <div class="star-rating">
                                        ${getStarRating(review.rating)}
                                    </div>
                                </div>
                            </div>
                            <p class="testi-text">
                                "${review.review_text || ''}"
                            </p>
                            <div class="vs-testi__top mb-0">
                                <div class="vs-testi__image">
                                    <img class="img1" src="assets/img/testimonial/testi-1-1.png" alt="testimonials">
                                </div>
                                <div class="vs-testi__author">
                                    <h3 class="vs-testi__title">${review.customer_name || 'Customer'}</h3>
                                </div>
                                <span class="quote-icon"><i class="fas fa-quote-left"></i></span>
                            </div>
                        </div>
                    `;
                });
                
                container.innerHTML = html;

                // Initialize or reinitialize Slick slider with proper error handling
                try {
                    if (jQuery('.testi-slider2').hasClass('slick-initialized')) {
                        jQuery('.testi-slider2').slick('unslick');
                    }
                    
                    jQuery('.testi-slider2').slick({
                        fade: true,
                        arrows: true,
                        dots: false,
                        infinite: true,
                        speed: 500,
                        slidesToShow: 1,
                        slidesToScroll: 1,
                        prevArrow: jQuery('[data-slick-prev=".testi-slider2"]'),
                        nextArrow: jQuery('[data-slick-next=".testi-slider2"]'),
                        autoplay: false
                    });
                    console.log('Slick slider initialized successfully');
                } catch (error) {
                    console.error('Error initializing Slick slider:', error);
                }
            }

            document.addEventListener('DOMContentLoaded', function() {
                loadTestimonials();
                setInterval(loadTestimonials, 60000);
            });
        </script>

    <!-- Include Footer -->
    <?php include 'footer.php'; ?>

    <!--==============================
        All Js File
    ============================== -->
    <!-- Jquery -->
    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <!-- Slick Slider -->
    <script src="assets/js/slick.min.js"></script>
    <!-- Bootstrap -->
    <script src="assets/js/bootstrap.min.js"></script>
    <!-- Magnific Popup -->
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <!-- imagesloaded -->
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <!-- Gsap -->
    <script src="assets/js/gsap.min.js"></script>
    <!-- ScrollTrigger -->
    <script src="assets/js/ScrollTrigger.min.js"></script>
    <!-- Gsap ScrollTo Plugin -->
    <script src="assets/js/gsap-scroll-to-plugin.js"></script>
    <!-- Split Text -->
    <script src="assets/js/SplitText.js"></script>
    <!-- lenis -->
    <script src="assets/js/lenis.min.js"></script>
    <!-- wow js -->
    <script src="assets/js/wow.min.js"></script>
    <!-- Main Js File -->
    <script src="assets/js/main.js"></script>

</body>

</html>
